﻿#include "escritura_float.h"

static const double pot10pos[]={1.0,10.0,100.0,1000.0,10000.0,100000.0,1000000.0,10000000.0, 1.0E8, 1.0E9};
static const double pot10neg[]={1.0,0.1,.01,.001,.0001,.00001,.000001,.0000001, 1.0E-8, 1.0E-9};
static const uint pot10int[]={1,10,100,1000,10000,100000,1000000,10000000, 100000000, 1000000000};

//Escribe dec cifras significativas
char8_t* str_float_prec(float fl, u8int dec, char8_t* s, char8_t mas){	//Asumed that s has enough space
	if(fl==0){
		if(mas!='\0') *s++=mas;
		*s++='0'; *s='\0'; return s;
	}
	if(fl<0){*s++='-'; fl=-fl;}
	elif(mas!='\0') *s++=mas;

	ifunlike(dec>9) dec=9;
	s8int d=log10n(fl);
	s8int dif=d-dec+1;
	uint fn;
	{double fpart;
	s8int j=dif;
	fpart=1;
	if(j<0){while(j<-9){fpart*=1.0E10; j+=10;}
		fpart*=pot10pos[-j];
	}else{while(j>9){fpart*=1.0E-10; j-=10;}
		fpart*=pot10neg[j];
	}
	fn=(uint)(ssint)(fl*(float)fpart+0.5F);
	ifunlike(fn==pot10int[dec]){fn=pot10int[dec-1]; d++; dif++;}
	}

	if(d<-3 || dif>3){
		str8___uint(s+1,fn);
		*s=*(s+1), s++;	*s='.'; s+=dec;
		*s++='E';
		if(d<0){*s='-'; d=-d;} else *s='+';
		s++;
		*s++=(char8_t)(d/10+'0');
		*s++=(char8_t)(d-10*(d/10)+'0');
	}else{
		if(d<0){
			d=-d-1;	//núm. de ceros tras la coma
			*s++='0'; *s++='.';
			for(;d>0;d--) *s++='0';
			s=str8___uint(s,fn);
		}else{
			s=str8___uint(s,fn);
			if(dif>=0){
				while(dif){dif--; *s++='0';}
			}else{
				char8_t *ptr=s++;
				do{dif++; *ptr=*(ptr-1), ptr--;}while(dif<0);
				*ptr='.';
			}
		}
	}
	*s='\0';
	return s;
}

//Escribe dec decimales
char8_t* str_float_dec(double fl, s8int dec, char8_t* s, char8_t mas, bint limpio){
	uint npart;
	char8_t *cb;

	if(fl==0){
		if(mas!='\0') *s++=mas;
		*s++='0'; *s='\0'; return s;
	}

	if(fl<0){*s++='-'; fl=-fl;}
	elif(mas) *s++=mas;
	if(dec<=0){
		s=str8___uint(s,(uint)(ssint)(fl+0.5F));
		return s;
	}

	if(dec>9) dec=9;
	float fm=(float)pot10neg[dec];
	fl+=0.5F*fm;
	if(fl<2.0F*fm){
		*s++='0'; *s++='.';
		for(;--dec;*s++='0');
		if(fl<fm) *s++='0';
		else *s++='1';
		*s='\0';
		return s;
	}

	npart=(uint)(ssint)fl;
	s=str8___uint(s,npart);
	fl-=(float)npart;
	fl*=(float)pot10pos[dec];
	npart=(uint)fl;
	*s='.';
	cb=s+dec;
	while(npart>=10){
		uint y=npart/10;
		*cb--=(char8_t)(npart-10*y+'0');
		npart=y;
	}
	*cb--=(char8_t)(npart+'0');
	while(cb!=s) *cb--='0';
	s+=dec;
	if(limpio){
		while(*s=='0') s--;
		if(*s=='.') s--;
	}
	*++s='\0';

	return s;
}

#define GCadds(gc,s) GC_adds(gc,s,return AT_NOMEM)
int crea_formula_simetrica(Growing_char *s, const char8_t* letra, u8int modelo, u16int params){
	bint b;

	b=false;
	if(params&1){
		GCadds(*s,letra); GCadds(*s,u8"1·s");
		b=true;
	}
	params>>=1;

	for(u8int i=2;i<=SIM_N;i++,params>>=1){
		if(!(params&1)) continue;
		if(b) GCadds(*s," + ");
		GCadds(*s,letra); Gadd(*s,char8_t,(char8_t)(i+'0'),return AT_NOMEM);
		GCadds(*s,polinomios_p[i][modelo-1]);
		b=true;
	}
	return 0;
}

int crea_formula_asim_rt(Growing_char *s, const char8_t* letra, u8int modelo, u16int params){
	bint b;
	char8_t cc[6];
	char8_t coskA[8], sinkA[8];

	cc[5]=cc[4]=cc[3]=0;
	*((uint*)coskA+1)=0;
	*((uint*)sinkA+1)=0;
	coskA[0]='c'; coskA[1]='o'; coskA[2]='s';		coskA[4]='A';
	sinkA[0]='s'; sinkA[1]='e'; sinkA[2]='n';		sinkA[4]='A';
	b=false;
	for(u8int i=1;i<=ASIM_N;i++,params>>=1){
		if(!(params&1)) continue;
		u8int j; s8int k;
		if(b) GCadds(*s," + ");
		GCadds(*s,letra);
		j=poli_asim[i];
		if(i<10){
			cc[0]=(char8_t)(i+'0');
			if(j<3){cc[1]=u8"·"[0]; cc[2]=u8"·"[1];}
			else{cc[1]='\0';}
		}else{
			u8int ib=i/10;
			cc[0]=(char8_t)(ib+'0');
			cc[1]=(char8_t)(i-10*ib+'0');
			if(j<3){cc[3]=u8"·"[0]; cc[3]=u8"·"[1];}
			else{cc[2]='\0';}
		}
		GCadds(*s,cc);
		const char8_t *ss=polinomios_pq[j][modelo-1];
		GCadds(*s,ss);
		if(j<3){GCadds(*s,cc+1);}
		k=S_asim[i];
		if(k==1) ss="cosA";
		elif(k==-1) ss="senA";
		elif(k>0){coskA[3]=(char8_t)(k+'0'); ss=coskA;}
		else{sinkA[3]=(char8_t)(-k+'0'); ss=sinkA;}
		GCadds(*s,ss);
		b=true;
	}
	return 0;
}

int crea_formula_asim_uv(Growing_char *s, const char8_t* letra, u8int modelo, u16int params, bint serie){
	bint b;
	char8_t cc[6];
	char8_t coskA[8], sinkA[8];

	for(u8int i=4;i<8;i++) coskA[i]=0,sinkA[i]=0;
	cc[5]=cc[4]=0;

	coskA[0]='u'; coskA[1]='(';		coskA[4]=')';
	sinkA[0]='v'; sinkA[1]='(';		sinkA[4]=')';
	if(serie==0){
		coskA[2]='-'; sinkA[2]='-';
	}else{
		coskA[2]='+'; sinkA[2]='+';
	}

	b=false;
	if(params&1){
		GCadds(*s,letra); GCadds(*s,u8"1·s^2·cos2A");
		b=true;
	}
	if(params&2){
		if(b) GCadds(*s," + ");
		GCadds(*s,letra); GCadds(*s,u8"2·s^2·sen2A");
		b=true;
	}
	params>>=2;

	for(u8int i=3;i<=ASIM_N;i++,params>>=1){
		if(!(params&1)) continue;
		u8int j; s8int k;
		if(b) GCadds(*s," + ");
		GCadds(*s,letra);
		j=poli_asim[i];
		if(i<10){
			cc[0]=(char8_t)(i+'0');
			if(j<3){cc[1]=u8"·"[0]; cc[2]=u8"·"[1]; cc[3]='\0';}
			else{cc[1]='\0';}
		}else{
			u8int ib=i/10;
			cc[0]=(char8_t)(ib+'0');
			cc[1]=(char8_t)(i-10*ib+'0');
			if(j<3){cc[2]=u8"·"[0]; cc[3]=u8"·"[1];}
			else{cc[2]='\0';}
		}
		GCadds(*s,cc);
		const char8_t *ss=polinomios_p[j][modelo-1];
		GCadds(*s,ss);
		if(j<3) GCadds(*s,cc+1);
		k=S_asim[i];
		if(k>0){coskA[3]=(char8_t)(k+'0'); ss=coskA;}
		else{sinkA[3]=(char8_t)(-k+'0'); ss=sinkA;}
		GCadds(*s,ss);
		b=true;
	}
	return 0;
}
sinline int crea_formula_uv_serie1(Growing_char *s, const char8_t* letra, u8int modelo, u16int params){
	return crea_formula_asim_uv(s,letra,modelo,params,0);
}
sinline int crea_formula_uv_serie2(Growing_char *s, const char8_t* letra, u8int modelo, u16int params){
	return crea_formula_asim_uv(s,letra,modelo,params,1);
}

void calcula_matriz(const Parametros_1* param_1, float A[4]){
	float D;

	A[0]=param_1->a;
	A[1]=param_1->b;
	D=param_1->lambda;
	D/=sqrtf(1-param_1->a*param_1->a-param_1->b*param_1->b);
	A[0]=(1+param_1->a)*D;
	A[3]=(1-param_1->a)*D;
	A[2]=A[1]=param_1->b*D;
	if(param_1->giro!=0){
		float cosk=cosf(param_1->giro);
		float sink=sinf(param_1->giro);
		float aux=A[0]*cosk-A[2]*sink;
		A[2]=A[0]*sink+A[2]*cosk;
		A[0]=aux;
		aux=A[1]*cosk-A[3]*sink;
		A[3]=A[1]*sink+A[3]*cosk;
		A[1]=aux;
	}
}
void calcula_matriz_dbl(const Parametros_1* param_1, double A[4]){
	double D;

	A[0]=param_1->a;
	A[1]=param_1->b;
	D=param_1->lambda;
	D/=sqrt(1-param_1->a*param_1->a-param_1->b*param_1->b);
	A[0]=(1+param_1->a)*D;
	A[3]=(1-param_1->a)*D;
	A[2]=A[1]=param_1->b*D;
	if(param_1->giro!=0){
		double cosk=cos(param_1->giro);
		double sink=sin(param_1->giro);
		double aux=A[0]*cosk-A[2]*sink;
		A[2]=A[0]*sink+A[2]*cosk;
		A[0]=aux;
		aux=A[1]*cosk-A[3]*sink;
		A[3]=A[1]*sink+A[3]*cosk;
		A[1]=aux;
	}
}
//sx, sy deben tener espacio. Escribe decp decimales para los parámetros de la traslación
void crea_formulac_medidasfoto(float ratio,Parametros_1* param_1, char8_t sx[],char8_t sy[], s8int decp){
	char8_t x[20],y[20];
	char8_t sm2[20],sm4[20];
	float A[4];

	if(param_1->Tx==0){x[0]='x'; x[1]='\0';}
	else{
		char8_t *cc;
		x[0]='('; x[1]='x';
		cc=str_float_dec(-param_1->Tx,decp,x+2,'+',true);
		*cc++=')'; *cc='\0';
		x[19]='\0';
	}
	if(param_1->Ty==0){y[0]='y'; y[1]='\0';}
	else{
		char8_t *cc;
		y[0]='('; y[1]='y';
		cc=str_float_dec(-param_1->Ty,decp,y+2,'+',true);
		*cc++=')'; *cc='\0';
		y[19]='\0';
	}

	calcula_matriz(param_1,A);
	if(ratio!=1.0F){
		if(ratio<0){
			A[1]=-A[1];
			A[3]=-A[3];
			ratio=-ratio;
		}
		A[0]*=ratio;
		A[2]*=ratio;
	}

	if(param_1->giro==0 && param_1->b==0){
		if(param_1->lambda!=1 || param_1->a!=0){
			str_float_prec(A[0],6,sx,'\0'); while(*sx) sx++;
			str_float_prec(A[3],6,sy,'\0'); while(*sy) sy++;
		}
		strcpy8(sx,x);
		strcpy8(sy,y);
	}else{
		float aa,B,C,D;
		char8_t *cc, *c2;
		s8int dec;
		if(fabsf(A[0])>=fabsf(A[2])){aa=A[0]; C=A[2];	cc=sx; c2=sy;}
		else{aa=A[2]; C=A[0];	cc=sy; c2=sx;}
		str_float_prec(aa,6,cc,'\0');
		for(; *cc!='\0' && *cc!='E'; cc++);
		if(*cc=='\0') str_float_dec(C,5-log10n(aa),c2,'\0',false);
		else{
			dec=6-log10n(aa)+log10n(C); if(dec<1) dec=1;
			str_float_prec(C,(u8int)dec,c2,'\0');
		}
		if(fabsf(A[1])>=fabsf(A[3])){B=A[1]; D=A[3];	cc=sm2; c2=sm4;}
		else{B=A[3]; D=A[1];	cc=sm4; c2=sm2;}
		str_float_prec(B,6,cc,'+');
		for(; *cc!='\0' && *cc!='E'; cc++);
		if(*cc=='\0') str_float_dec(D,5-log10n(B),c2,'+',false);
		else{
			dec=6-log10n(B)+log10n(D); if(dec<1) dec=1;
			str_float_prec(D,(u8int)dec,c2,'+');
		}
		while(*sx) sx++; strbuild8(sx,x," ",sm2,y,NULL);
		while(*sy) sy++; strbuild8(sy,x," ",sm4,y,NULL);
	}
}

//k ha de ser <10 y >=1
//d: -log10n de la última cifra que debe escribirse
//permite_sci: si se permite abreviar con notación científica
void escribe_monomio(Bufferto8 *buf, bint bhtml, float coef, s8int d, bint permite_sci, char8_t letra, u8int k){
	if(permite_sci && (fabsf(coef)<0.001F || d<-3)){
		d+=log10n(coef)+1; if(d<1) d=1;
		setbuf_relativep(buf,(u8int)d);
	}else{
		setbuf_absolutep(buf,d);
	}
	towrite8_float(buf,coef);
	toput_char(buf,letra);
	if(k>1){
		char8_t c=(char8_t)k+'0';
		if(bhtml){towrite8_string(buf,"<sup>"); toput_char(buf,c); towrite8_string(buf,"</sup>");}
		else{toput_char(buf,'^'); toput_char(buf,c);}
	}
}
void crea_formulac_simetricas(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xradsim,s8int decf){
	float a[5];
	colapsa_serie_p(modelo,Xradsim,a);

	setbuf_absolutep(buf,decf);
	setbuf_nolimpio(buf);
	for(u8int i=0;i<SIM_N;i++){
		float f;
		if((f=a[i])==0) continue;
		if(buf->maschar) toput_char(buf,' ');
		towrite8_float(buf,f);
		toput_char(buf,'s');
		if(i){
			char8_t c=(char8_t)i+'1';
			if(modelo==CAL_MODPOL_IMPAR) c+=(char8_t)i;
			if(bhtml){towrite8_string(buf,"<sup>"); toput_char(buf,c); towrite8_string(buf,"</sup>");}
			else{toput_char(buf,'^'); toput_char(buf,c);}
		}
		buf->maschar='+';
	}
	buf->maschar='\0';
}
void crea_formulac_simetricar(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xradsim,float semidiag,s8int decf){
	float a[5];
	float s2=semidiag*semidiag;
	float s3=s2*semidiag;
	float s4=s2*s2;
	float s5=s4*semidiag;
	float logs, paso;

	colapsa_serie_p(modelo,Xradsim,a);
	switch(modelo){
	  case CAL_MODPOL_IMPAR:
		a[0]/=semidiag;
		a[1]/=s3;
		a[2]/=s5;
		a[3]/=s5*s2;
		a[4]/=s5*s4;
		break;
	  case CAL_MODPOL_COMPLETO:
		a[0]/=semidiag;
		a[1]/=s2;
		a[2]/=s3;
		a[3]/=s4;
		a[4]/=s5;
		break;
	}

	logs=log10f(semidiag);
	if(modelo==CAL_MODPOL_COMPLETO) paso=2.0F*logs;
	else paso=logs;

	setbuf_nolimpio(buf);
	setbuf_scientific(buf);
	for(u8int i=0;i<SIM_N;i++,logs+=paso){
		float f;
		s8int d;
		u8int k;
		if((f=a[i])==0) continue;

		k=i+1;
		if(modelo==CAL_MODPOL_IMPAR) k+=i;
		if(buf->maschar) toput_char(buf,' ');
		d=decf+(s8int)(logs+0.9F);
		escribe_monomio(buf,bhtml,f,d,true,'r',k);
		buf->maschar='+';
	}
	buf->maschar='\0';
}

void colapsa_asimetrica(u8int modelo,const float Xradasim[ASIM_N], float a[ASIM_N], bint b01){
	float f;

	if(b01){a[0]=Xradasim[0];	a[1]=Xradasim[1];}	//s^2·S(1)
	else{a[0]=0; a[1]=0;}
	a[2]=0; a[3]=0;	//s^4·S(1)
	a[4]=Xradasim[4];	a[5]=Xradasim[5];	//s^1·S(2)
	a[6]=0; a[7]=0;	//s^6·S(1)
	a[8]=0; a[9]=0;	//s^3·S(2)
	a[10]=Xradasim[10]; a[11]=Xradasim[11];	//s^2·S(3)
	switch(modelo){
	  case CAL_MODPOL_IMPAR:
		if((f=Xradasim[2])!=0){//s^(2,4)·S(1)
			a[2]+=2.5F*f;		a[0]-=1.5F*f;
		}
		if((f=Xradasim[3])!=0){
			a[3]+=2.5F*f;		a[1]-=1.5F*f;
		}
		if((f=Xradasim[6])!=0){//s^(2,4,6)·S(1)
			a[6]+=6.4F*f;		a[2]-=7.2F*f;		a[0]+=1.8F*f;
		}
		if((f=Xradasim[7])!=0){
			a[7]+=6.4F*f;		a[3]-=7.2F*f;		a[1]+=1.8F*f;
		}
		if((f=Xradasim[8])!=0){//s^(1,3)·S(2)
			a[8]+=2.F*f;	a[4]-=f;
		}
		if((f=Xradasim[9])!=0){//s^(1,3)·S(2)
			a[9]+=2.F*f;	a[5]-=f;
		}
		break;
	  case CAL_MODPOL_COMPLETO:
		if((f=Xradasim[2])!=0){//s^(2,4)·S(1)
			a[2]+=4.F*f;	a[0]-=3.F*f;
		}
		if((f=Xradasim[3])!=0){
			a[3]+=4.F*f;	a[1]-=3.F*f;
		}
		if((f=Xradasim[6])!=0){//s^(2,4,6)·S(1)
			a[6]+=14.5F*f;	a[2]-=20.3F*f;	a[0]+=6.8F*f;
		}
		if((f=Xradasim[7])!=0){
			a[7]+=14.5F*f;	a[3]-=20.3F*f;	a[1]+=6.8F*f;
		}
		if((f=Xradasim[8])!=0){//s^(1,3)·S(2)
			a[8]+=3.0F*f;		a[4]-=2.0F*f;
		}
		if((f=Xradasim[9])!=0){//s^(1,3)·S(2)
			a[9]+=3.0F*f;		a[5]-=2.0F*f;
		}
		break;
	}
}
sinline void colapsa_asimetrica_rt(u8int modelo,const float* Xserie, float* a){
	colapsa_asimetrica(modelo,Xserie,a,true);
}
sinline void colapsa_asimetrica_uv(u8int modelo,const float* Xserie, float* a){
	colapsa_asimetrica(modelo,Xserie,a,false);
}
void crea_formulac_asimetrica_rt_letra(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xradasim,char8_t letra,float semidiag,s8int decf){	//Si semidiag es 0 no se divide por la semidiagonal
	float a[ASIM_N];
	char8_t trig[8];
	bint bsemi=semidiag!=0;
	float s_pow[7];
	if(bsemi){
		s_pow[0]=1;		s_pow[1]=semidiag;		s_pow[2]=semidiag*semidiag;
		s_pow[3]=s_pow[2]*semidiag;
		s_pow[4]=s_pow[3]*semidiag;
		s_pow[5]=s_pow[4]*semidiag;
		s_pow[6]=s_pow[5]*semidiag;
	}
	colapsa_asimetrica_rt(modelo,Xradasim,a);

	setbuf_nolimpio(buf);
	setbuf_scientific(buf);
	trig[0]=u8"·"[0]; trig[1]=u8"·"[1];
	for(u8int i=0;i<ASIM_N;){
		u8int j;
		union{s8int s; u8int u;} k;		//Clause 6.2.6.2. of the standard, Para. 5, guarantees that if s
		float f;								//holds a positive value the reading of u retrives that same value.
		s8int d;
		if((f=a[i])==0){i++; continue;}
		i++;//Cuidado
		j=poli_asim[i];
		if(modelo==CAL_MODPOL_COMPLETO) j=(j>>1)+1;
		if(buf->maschar) toput_char(buf,' ');
		d=decf;
		if(bsemi){
			float div=s_pow[j];
			f/=div;
			d+=(s8int)(log10(div)+.9F);
		}
		escribe_monomio(buf,bhtml,f,d,bsemi,letra,j);

		k.s=S_asim[i];
		if(k.s>0){trig[2]='c'; trig[3]='o'; trig[4]='s';}
		else{trig[2]='s'; trig[3]='e'; trig[4]='n'; k.s=-k.s;}	//one would logically write k.u=-k.s, but compilers aren't clever reporting warnings
		if(k.u==1){trig[5]='A'; trig[6]='\0';}
		else{trig[5]=(char8_t)(k.u+'0'); trig[6]='A'; trig[7]='\0';}
		towrite8_string(buf,trig);
		buf->maschar='+';
	}
	buf->maschar='\0';
}

sinline void crea_formulac_asimetrica_rt_s(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xradasim,s8int decf){
	crea_formulac_asimetrica_rt_letra(buf,bhtml,modelo,Xradasim,'s',0.F,decf);
}
sinline void crea_formulac_asimetrica_rt_r(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xradasim,float semidiag,s8int decf){
	crea_formulac_asimetrica_rt_letra(buf,bhtml,modelo,Xradasim,'r',semidiag,decf);
}

void crea_formulac_radasim_uv_letra(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xserie1,float* Xserie2, char8_t letra,float semidiag,s8int decf){	//Si semidiag es 0 no se divide por la semidiagonal
	float a1[ASIM_N],b1[ASIM_N];
	char8_t trigc[9]=u8"·cosAAA",	//the · takes two places in UTF-8
			trigs[9]=u8"·senAAA";
	bint bsemi=semidiag!=0;
	float s_pow[7];
	if(bsemi){
		s_pow[0]=1;		s_pow[1]=semidiag;		s_pow[2]=semidiag*semidiag;
		s_pow[3]=s_pow[2]*semidiag;
		s_pow[4]=s_pow[3]*semidiag;
		s_pow[5]=s_pow[4]*semidiag;
		s_pow[6]=s_pow[5]*semidiag;
	}

	if(Xserie1!=NULL) colapsa_asimetrica_uv(modelo,Xserie1,a1);	else{zeroset_float(a1,ASIM_N);}
	if(Xserie2!=NULL) colapsa_asimetrica_uv(modelo,Xserie2,b1);	else{zeroset_float(b1,ASIM_N);}
	if(Xserie1!=NULL){
		a1[0]+=Xserie1[0];
		a1[1]+=Xserie1[1];
	}

	setbuf_nolimpio(buf);
	setbuf_scientific(buf);
	for(u8int i=0;i<ASIM_N;){
		u8int j;
		u8int k;
		float f,g;
		f=a1[i]+b1[i]; i++;
		g=a1[i]-b1[i];
		if(f==0 && g==0){i++; continue;}

		k=(u8int)S_asim[i];	//i is odd, hence S_asim[i] will be possitive
		if(k==1){
			trigc[5]='A'; trigc[6]='\0';
			trigs[5]='A'; trigs[6]='\0';
		}else{
			trigc[5]=(char8_t)(k+'0'); trigc[6]='A'; trigc[7]='\0';
			trigs[5]=(char8_t)(k+'0'); trigs[6]='A'; trigs[7]='\0';
		}
		j=poli_asim[i];
		if(modelo==CAL_MODPOL_COMPLETO) j=(j>>1)+1;

		if(f!=0){
			if(buf->maschar) toput_char(buf,' ');
			s8int d=decf;
			if(bsemi){
				float div=s_pow[j];
				f/=div;
				d+=(s8int)(log10(div)+.9F);
			}
			escribe_monomio(buf,bhtml,f,d,bsemi,letra,j);
			towrite8_string(buf,trigc);
			buf->maschar='+';
		}
		i++;
		if(g!=0){
			if(buf->maschar) toput_char(buf,' ');
			s8int d=decf;
			if(bsemi){
				float div=s_pow[j];
				g/=div;
				d+=(s8int)(log10(div)+.9F);
			}
			escribe_monomio(buf,bhtml,g,d,bsemi,letra,j);
			towrite8_string(buf,trigs);
			buf->maschar='+';
		}
	}
	buf->maschar='\0';
}

sinline void crea_formulac_radasim_uv(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xserie1,float* Xserie2, s8int decf){
	crea_formulac_radasim_uv_letra(buf,bhtml,modelo,Xserie1,Xserie2,'s',0.F,decf);
}
void crea_formulac_tanasim_uv_letra(Bufferto8 *buf, bint bhtml, u8int modelo,float* Xserie1,float* Xserie2, char8_t letra,float semidiag,s8int decf){	//Si semidiag es 0 no se divide por la semidiagonal
	float a1[ASIM_N],b1[ASIM_N];
	char8_t trigc[9]=u8"·cosAAA",
			trigs[9]=u8"·senAAA";
	bint bsemi=semidiag!=0;
	float s_pow[7];
	if(bsemi){
		s_pow[0]=1;		s_pow[1]=semidiag;		s_pow[2]=semidiag*semidiag;
		s_pow[3]=s_pow[2]*semidiag;
		s_pow[4]=s_pow[3]*semidiag;
		s_pow[5]=s_pow[4]*semidiag;
		s_pow[6]=s_pow[5]*semidiag;
	}

	if(Xserie1!=NULL) colapsa_asimetrica_uv(modelo,Xserie1,a1);	else{zeroset_float(a1,ASIM_N);}
	if(Xserie2!=NULL) colapsa_asimetrica_uv(modelo,Xserie2,b1);	else{zeroset_float(b1,ASIM_N);}
	if(Xserie2!=NULL){
		b1[1]+=Xserie2[0];
		b1[0]+=Xserie2[1];
	}

	setbuf_nolimpio(buf);
	setbuf_scientific(buf);
	for(u8int i=0;i<ASIM_N;){
		u8int j,k;
		float f,g;
		g=b1[i]-a1[i]; i++;
		f=a1[i]+b1[i];
		if(f==0 && g==0){i++; continue;}

		k=(u8int)S_asim[i];	//i is odd --> k is >0
		if(k==1){
			trigc[5]='A'; trigc[6]='\0';
			trigs[5]='A'; trigs[6]='\0';
		}else{
			trigc[5]=(char8_t)(k+'0'); trigc[6]='A'; trigc[7]='\0';
			trigs[5]=(char8_t)(k+'0'); trigs[6]='A'; trigs[7]='\0';
		}
		j=poli_asim[i];
		if(modelo==CAL_MODPOL_COMPLETO) j=(j>>1)+1;

		if(f!=0){
			if(buf->maschar) toput_char(buf,' ');
			s8int d=decf;
			if(bsemi){
				float div=s_pow[j];
				f/=div;
				d+=(s8int)(log10(div)+.9F);
			}
			escribe_monomio(buf,bhtml,f,d,bsemi,letra,j);
			towrite8_string(buf,trigc);
			buf->maschar='+';
		}
		i++;
		if(g!=0){
			if(buf->maschar) toput_char(buf,' ');
			s8int d=decf;
			if(bsemi){
				float div=s_pow[j];
				g/=div;
				d+=(s8int)(log10(div)+.9F);
			}
			escribe_monomio(buf,bhtml,g,d,bsemi,letra,j);
			towrite8_string(buf,trigs);
			buf->maschar='+';
		}
	}
	buf->maschar='\0';
}
sinline void crea_formulac_tanasim_uv(Bufferto8 *buf, bint bhtml,u8int modelo,float* Xserie1,float* Xserie2, s8int decf){
	crea_formulac_tanasim_uv_letra(buf,bhtml,modelo,Xserie1,Xserie2,'s',0.F,decf);
}

void escribe_conocidos(Bufferto8 *finf, u8int calcula_1,u8int calcula_E,u8int calcula_I, Valores_1* val_1, Valores_E* val_E, Valores_I* val_I,double ccpi, const char16_t *unip, const char16_t *unif){
	setbuf_absolute(finf);
	bint linea=false;
	bint b=false;
	if(calcula_1!=0x3F){
		towrite8_string(finf,TEXTOS[38]);
		if(calcula_1==0 && val_1->Tx==0 && val_1->Ty==0 && val_1->giro==0 && val_1->lambda==1 && val_1->esc_xy==1 && val_1->delta==0){
			towrite8_string(finf,TEXTOS[39]);
		}else{
			if(val_1->Tx!=0 || val_1->Ty!=0) b=true;
			if(!(calcula_1&1)){
				towrite8(finf,'s',"          Tx        ", 'f',val_1->Tx, 0);	if(b){towrite8(finf,' ', 'w',unip, 0);} toput_char(finf,'\n');
			}
			if(!(calcula_1&2)){
				towrite8(finf,'s',"          Ty        ", 'f',val_1->Ty, 0);	if(b){towrite8(finf,' ', 'w',unip, 0);} toput_char(finf,'\n');
			}
			if(!(calcula_1&4)){
				towrite8(finf,'s',TEXTOS[40], 'f',val_1->giro*ccpi, '\n',0);
			}
			if(!(calcula_1&8)){
				towrite8(finf,'s',"          esc       ", 'f',val_1->lambda);
				if(val_1->lambda!=1.0){towrite8(finf,' ', 'w',unif,'/', 'w',unip);}
				toput_char(finf,'\n');
			}
			if(!(calcula_1&0x10)) towrite8(finf,'s',"          esc x/y   ", 'f',val_1->esc_xy, '\n',0);
			if(!(calcula_1&0x20)) towrite8(finf,'s',"          delta     ", 'f',val_1->delta*ccpi, '\n',0);
		}
		linea=true;
	}
	if(calcula_E!=0x3F){
		if(linea) toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[41]);
		if(!(calcula_E&1)) towrite8(finf,'s',"          X        ", 'f',val_E->X, '\n',0);
		if(!(calcula_E&2)) towrite8(finf,'s',"          Y        ", 'f',val_E->Y, '\n',0);
		if(!(calcula_E&4)) towrite8(finf,'s',"          Z        ", 'f',val_E->Z, '\n',0);
		if(!(calcula_E&8)) towrite8(finf,'s',"          W        ", 'f',val_E->W*ccpi, '\n',0);
		if(!(calcula_E&0x10)) towrite8(finf,'s',"         PHI       ", 'f',val_E->PHI*ccpi, '\n',0);
		if(!(calcula_E&0x20)) towrite8(finf,'s',"          K        ", 'f',val_E->K*ccpi, '\n',0);
		linea=true;
	}
	if(calcula_I!=0x07){
		if(linea) toput_char(finf,'\n');
		b=(val_I->x!=0 || val_I->y!=0);
		towrite8_string(finf,TEXTOS[42]);
		if(!(calcula_I&2)){towrite8(finf,'s',"          xp       ", 'f',val_I->x, 0);	if(b){towrite8(finf,' ', 'w',unif, 0);} toput_char(finf,'\n');}
		if(!(calcula_I&4)){towrite8(finf,'s',"          yp       ", 'f',val_I->y, 0);	if(b){towrite8(finf,' ', 'w',unif, 0);} toput_char(finf,'\n');}
		if(!(calcula_I&1)){towrite8(finf,'s',"          f        ", 'f',val_I->f,' ', 'w',unif, '\n',0);}
	}
}
int escribe_acalcular(Bufferto8 *finf, u8int calcula_1,u8int calcula_E,u8int calcula_I, Valores_1* val_1, Valores_E* val_E, Valores_I* val_I, Config_distorsion* config_dist,double ccpi,const char16_t *unip,const char16_t *unif){
	u8int modelo;

	setbuf_relative(finf);
	bint linea=false;
	if(calcula_1!=0){
		towrite8_string(finf,TEXTOS[38]);
		if(calcula_1&1){
			towrite8_string(finf,"          Tx        ");
			if(isfinite(val_1->Tx)) towrite8(finf,'f',val_1->Tx,' ', 'w',unip, 0);
			toput_char(finf,'\n');
		}
		if(calcula_1&2){
			towrite8_string(finf,"          Ty        ");
			if(isfinite(val_1->Ty)) towrite8(finf,'f',val_1->Ty,' ', 'w',unip, 0);
			toput_char(finf,'\n');
		}
		if(calcula_1&4){
			towrite8_string(finf,TEXTOS[40]);
			if(isfinite(val_1->giro)) towrite8_double(finf,val_1->giro*ccpi);
			toput_char(finf,'\n');
		}
		if(calcula_1&8){
			towrite8_string(finf,"          esc       ");
			if(isfinite(val_1->lambda)) towrite8(finf,'f',val_1->lambda,' ', 'w',unif,'/', 'w',unip, 0);
			toput_char(finf,'\n');
		}
		if(calcula_1&0x10){
			towrite8_string(finf,"          esc x/y   ");
			if(isfinite(val_1->esc_xy)) towrite8_double(finf,val_1->esc_xy);
			toput_char(finf,'\n');
		}
		if(calcula_1&0x20){
			towrite8_string(finf,"          delta     ");
			if(isfinite(val_1->delta)) towrite8_double(finf,val_1->delta*ccpi);
			toput_char(finf,'\n');
		}
		linea=true;
	}
	if(calcula_E!=0){
		if(linea) toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[41]);
		if(calcula_E&1){
			towrite8_string(finf,"          X");
			if(isfinite(val_E->X)) towrite8(finf,'s',"        ", 'f',val_E->X, 0);
			toput_char(finf,'\n');
		}
		if(calcula_E&2){
			towrite8_string(finf,"          Y");
			if(isfinite(val_E->Y)) towrite8(finf,'s',"        ", 'f',val_E->Y, 0);
			toput_char(finf,'\n');
		}
		if(calcula_E&4){
			towrite8_string(finf,"          Z");
			if(isfinite(val_E->Z)) towrite8(finf,'s',"        ", 'f',val_E->Z, 0);
			toput_char(finf,'\n');
		}
		if(calcula_E&8){
			towrite8_string(finf,"          W");
			if(isfinite(val_E->W)) towrite8(finf,'s',"        ", 'f',val_E->W*ccpi, 0);
			toput_char(finf,'\n');
		}
		if(calcula_E&0x10){
			towrite8_string(finf,"         PHI");
			if(isfinite(val_E->PHI)) towrite8(finf,'s',"       ", 'f',val_E->PHI*ccpi, 0);
			toput_char(finf,'\n');
		}
		if(calcula_E&0x20){
			towrite8_string(finf,"          K");
			if(isfinite(val_E->K)) towrite8(finf,'s',"        ", 'f',val_E->K*ccpi, 0);
			toput_char(finf,'\n');
		}
		linea=true;
	}
	if(calcula_I!=0){
		if(linea) toput_char(finf,'\n');
		towrite8_string(finf,TEXTOS[42]);
		if(calcula_I&2){
			towrite8_string(finf,"          xp");
			if(isfinite(val_I->x)) towrite8(finf,'s',"       ", 'f',val_I->x,' ', 'w',unif, 0);
			toput_char(finf,'\n');
		}
		if(calcula_I&4){
			towrite8_string(finf,"          yp");
			if(isfinite(val_I->y)) towrite8(finf,'s',"       ", 'f',val_I->y,' ', 'w',unif, 0);
			toput_char(finf,'\n');
		}
		if(calcula_I&1){
			towrite8_string(finf,"          f");
			if(isfinite(val_I->f)) towrite8(finf,'s',"       ", 'f',val_I->f,' ', 'w',unif, 0);
			toput_char(finf,'\n');
		}
		linea=true;
	}
	if(linea) toput_char(finf,'\n');
	linea=true;
	ifz(modelo=config_dist->modelo_poli){
		towrite8_string(finf,TEXTOS[43]);
	}else{
		towrite8(finf,'s',TEXTOS[44], 's',TEXTOS[45], 'f',config_dist->semidiag,' ', 'w',unif, 's',TEXTOS[46], 's',TEXTOS[0], 's',TEXTOS[modelo], '\n',0);
		towrite8(finf,'s',"                      s=r/", 'f',config_dist->semidiag, 0);
		if(config_dist->modelo_asim!=0 && (config_dist->param_asim1!=0 || config_dist->param_asim2!=0))
			towrite8_string(finf,"      cosA=x/r , sinA=y/r");
		toput_char(finf,'\n');

		Growing_char formula;
		GC_initialize(formula,96,return AT_NOMEM);
		if(config_dist->param_radsim==0){
			towrite8_string(finf,TEXTOS[47]);
		}else{
			towrite8_string(finf,TEXTOS[67]);
			ifunlike(crea_formula_simetrica(&formula,"a",config_dist->modelo_poli,config_dist->param_radsim)){free(formula.ppio); return AT_NOMEM;}
			towrite8(finf,'s',"            Dr= ", 's',formula.ppio, '\n',0);
			if((calcula_1&8) || (calcula_I&1)){
				towrite8_string(finf,TEXTOS[48]);
				switch(config_dist->condicion_radsim){
					case CAL_CONDICIONR_ORTO: towrite8_string(finf,TEXTOS[49]); break;
					case CAL_CONDICIONR_R1: towrite8(finf,'s',"Dr(", 'f',config_dist->r1, 's',")=0\n", 0); break;
					case CAL_CONDICIONR_MM: towrite8_string(finf,TEXTOS[50]); break;
				}
			}
		}
		if(config_dist->param_tansim==0){
			towrite8_string(finf,TEXTOS[51]);
		}else{
			towrite8_string(finf,TEXTOS[68]);
			GC_reswitch(formula);
			ifunlike(crea_formula_simetrica(&formula,"b",config_dist->modelo_poli,config_dist->param_tansim)){free(formula.ppio); return AT_NOMEM;}
			towrite8(finf,'s',"            Dt= ", 's',formula.ppio, '\n',0);
		}
		modelo=config_dist->modelo_asim;
		if(modelo==0){
			towrite8_string(finf,TEXTOS[52]);
		}else{
			towrite8(finf,'s',TEXTOS[53], 's',TEXTOS[8+modelo], '\n',0);
			GC_reswitch(formula);
			switch(modelo){
			  case CAL_MODASIM_RADTAN:
				if(config_dist->param_asim1!=0){
					ifunlike(crea_formula_asim_rt(&formula,"c",config_dist->modelo_poli,config_dist->param_asim1)){free(formula.ppio); return AT_NOMEM;}
					towrite8(finf,'s',"            Dr= ", 's',formula.ppio, '\n',0);
				}
				if(config_dist->param_asim2!=0){
					GC_reswitch(formula);
					ifunlike(crea_formula_asim_rt(&formula,"d",config_dist->modelo_poli,config_dist->param_asim2)){free(formula.ppio); return AT_NOMEM;}
					towrite8(finf,'s',"            Dt= ", 's',formula.ppio, '\n',0);
				}
				break;
			  case CAL_MODASIM_VECTOR:
				ifunlike(crea_formula_uv_serie1(&formula,"c",config_dist->modelo_poli,config_dist->param_asim1)){free(formula.ppio); return AT_NOMEM;}
				towrite8(finf,'s',"            Serie 1: ", 's',formula.ppio, '\n',0);
					GC_reswitch(formula);
				ifunlike(crea_formula_uv_serie2(&formula,"d",config_dist->modelo_poli,config_dist->param_asim2)){free(formula.ppio); return AT_NOMEM;}
				towrite8(finf,'s',"            Serie 2: ", 's',formula.ppio, '\n',0);
				break;
			}
		}//if otras
		free(formula.ppio);
	}//if distorsion
	return 0;
}

//escribe decp decimales para la traslación
void escribe_todo_1(Bufferto8 *finf, float ratio, u8int calcula_1,Parametros_1* param_1,float ccpi, float vv,float*N,uint n,uint n_afin, const char16_t *unip,const char16_t* unif, s8int decp){
	float ke[2];
	n+=1;
	s8int d;

	if(calcula_1==0 && ratio==1.0F && param_1->Tx==0 && param_1->Ty==0 && param_1->giro==0 && param_1->lambda==1 && param_1->a==0 && param_1->b==0){
		towrite8_string(finf,TEXTOS[39]);
		return;
	}
	if(ccpi>50) d=4;
	elif(ccpi>5) d=5;
	else d=6;

	toput_char(finf,' '); towrite8_string(finf,TEXTOS[54]);
	if(!(calcula_1&3) && param_1->Tx==0 && param_1->Ty==0){
		towrite8_string(finf,"                Tx=          0\n");
		towrite8_string(finf,"                Ty=          0\n");
	}else{
		towrite8_string(finf,"                Tx= ");
		setbuf_absolutep(finf,decp);
		if(!(calcula_1&1)) setbuf_limpio(finf);
		towrite8_aligned_double(finf,param_1->Tx,10);
		toput_char(finf,' '); towrite8_string16_utf8(finf,unip);
		if(calcula_1&1){
			setbuf_relativep(finf,2);
			towrite8_string(finf,"   ");
			towrite8_aligned_float(finf,sqrtf(vv*N[7*n]),9);
		}else{
			 setbuf_nolimpio(finf);
		}
		toput_char(finf,'\n');

		towrite8_string(finf,"                Ty= ");
		setbuf_absolutep(finf,decp);
		if(!(calcula_1&2)) setbuf_limpio(finf);
		towrite8_aligned_double(finf,param_1->Ty,10);
		toput_char(finf,' '); towrite8_string16_utf8(finf,unip);
		if(calcula_1&2){
			setbuf_relativep(finf,2);
			towrite8_string(finf,"   ");
			towrite8_aligned_float(finf,sqrtf(vv*N[8*n]),9);
		}else{
			 setbuf_nolimpio(finf);
		}
		toput_char(finf,'\n');
	}

	u8int k1;
	{const char16_t* c=unip;
	 for(k1=10;*c++;k1++);}

	towrite8_string(finf,TEXTOS[55]);
	if(!(calcula_1&4) && param_1->giro==0){
		towrite8_string(finf,"         0\n");
	}else{
		setbuf_absolutep(finf,d);
		if(!(calcula_1&4)) setbuf_limpio(finf);
		towrite8_aligned_double(finf,param_1->giro*ccpi,10);
		if(calcula_1&4){
			setbuf_relativep(finf,2);
			towrite8_string(finf,"   ");
			towrite8_aligned_float(finf,sqrtf(vv*N[5*n]*ccpi),k1);
		}else{
			 setbuf_nolimpio(finf);
		}
		toput_char(finf,'\n');
	}
	setbuf_relative(finf);
	if(!(calcula_1&8) && param_1->lambda==1){
		towrite8_string(finf,"               esc=          1\n");
	}else{
		towrite8_string(finf,"               esc= ");
		finf->prec.signi=6;
		if(!(calcula_1&8)) setbuf_limpio(finf);
		towrite8_aligned_double(finf,param_1->lambda,10);
		if(calcula_1&8){
			finf->prec.signi=2;
			towrite8_string(finf,"   ");
			towrite8_aligned_float(finf,sqrtf(vv*N[6*n]),k1);
		}else{
			 setbuf_nolimpio(finf);
		}
		toput_char(finf,'\n');
	}
	afin_ke___ab_fl(param_1->a,param_1->b,ke);
	if(!(calcula_1&0x10) && param_1->a==0){
		towrite8_string(finf,"           esc x/y=          1\n");
	}else{
		towrite8_string(finf,"           esc x/y= ");
		finf->prec.signi=6;
		if(!(calcula_1&0x10)) setbuf_limpio(finf);
		towrite8_aligned_double(finf,ke[0],10);
		if(calcula_1&0x10){
			finf->prec.signi=2;
			towrite8_string(finf,"   ");
			towrite8_aligned_float(finf,2*sqrtf(vv*N[n_afin*n]),k1);
		}else{
			 setbuf_nolimpio(finf);
		}
		toput_char(finf,'\n');
	}
	if(!(calcula_1&0x20) && param_1->b==0){
		towrite8_string(finf,"             delta=          0\n");
	}else{
		towrite8_string(finf,"             delta= ");
		setbuf_absolutep(finf,d);
		if(!(calcula_1&0x20)) setbuf_limpio(finf);
		towrite8_aligned_double(finf,ke[1]*ccpi,10);
		if(calcula_1&0x20){
			setbuf_relativep(finf,2);
			towrite8_string(finf,"   ");
			towrite8_aligned_float(finf,2*sqrtf(vv*N[(n_afin+1)*n])*ccpi,k1);
		}else{
			 setbuf_nolimpio(finf);
		}
		toput_char(finf,'\n');
	}
	towrite8_string(finf,TEXTOS[56]);
	char8_t sx[80], sy[80];
	crea_formulac_medidasfoto(ratio,param_1,sx,sy,decp);
	towrite8(finf,'s',"              xf= ",'s',sx,'s',"      (x,y): ",'w',unip,'s',",  (xf,yf): ",'w',unif,'s',"\n              yf= ",'s',sy,'s',"\n",0);
}

void escribe_todo_E(Bufferto8 *finf, u8int calcula_E,Parametros_valores* param_valores,double k,double ccpi, float vv,float* N,uint n, const char16_t *unit){
	double M[3][3];
	Giro3D_double G;
	G.ω=param_valores->W;
	G.φ=param_valores->PHI;
	G.κ=k;
	n+=1;
	double* paux;
	char8_t X[3]={'X','Y','Z'};
	u8int k1;
	s8int d, decp;
	float precX[3];
	float faux;
	float fccpi=(float)ccpi;

	if(ccpi>50) d=4;
	elif(ccpi>5) d=5;
	else d=6;

	precX[0]=sqrtf(vv*N[0]);
	precX[1]=sqrtf(vv*N[n]);
	precX[2]=sqrtf(vv*N[(n<<1)]);

	if(precX[1]<precX[0]) faux=precX[1];
	else faux=precX[0];
	if(precX[2]<faux) faux=precX[2];
	decp=decimales_f(faux);

	toput_char(finf,' '); towrite8_string(finf,TEXTOS[54]);

	paux=(double*) param_valores;
	for(u8int i=0,l=calcula_E;i<3;i++,l>>=1,paux++){
		towrite8(finf,'s',"               ", 'c',X[i], 's',"= ", 0);
		setbuf_absolutep(finf,decp);
		towrite8_aligned_double(finf,*paux,12);
		towrite8(finf,' ', 'w',unit, 0);
		if(l&1){
			setbuf_relativep(finf,2);
			towrite8_string(finf,"    ");
			towrite8_aligned_float(finf,precX[i],9);
		}
		toput_char(finf,'\n');
	}

	{const char16_t* c=unit;
	 for(k1=10;*c++;k1++);}

	towrite8_string(finf,"               W= ");
	setbuf_absolutep(finf,d);
	towrite8_aligned_double(finf,G.ω*ccpi,12);
	if(calcula_E&8){
		setbuf_relativep(finf,2);
		towrite8_string(finf,"    ");
		towrite8_aligned_float(finf,sqrtf(vv*N[3*n])*fccpi,k1);
	}
	toput_char(finf,'\n');

	towrite8_string(finf,"             PHI= ");
	setbuf_absolutep(finf,d);
	towrite8_aligned_double(finf,G.φ*ccpi,12);
	if(calcula_E&0x10){
		setbuf_relativep(finf,2);
		towrite8_string(finf,"    ");
		towrite8_aligned_float(finf,sqrtf(vv*N[4*n])*fccpi,k1);
	}
	toput_char(finf,'\n');

	towrite8_string(finf,"               K= ");
	setbuf_absolutep(finf,d);
	towrite8_aligned_double(finf,G.κ*ccpi,12);
	if(calcula_E&0x20){
		setbuf_relativep(finf,2);
		towrite8_string(finf,"    ");
		towrite8_aligned_float(finf,sqrtf(vv*N[5*n])*fccpi,k1);
	}
	toput_char(finf,'\n');

	towrite8_string(finf,TEXTOS[58]);
	MatrizRot_ωφκ(G,M);
	setbuf_absolutep(finf,6);
	double *pM=M[0];
	dontimes(3,){
		towrite8_string(finf,"          ");
		towrite8_aligned_double(finf,*pM++,10); toput_char(finf,' ');
		towrite8_aligned_double(finf,*pM++,10); toput_char(finf,' ');
		towrite8_aligned_double(finf,*pM++,10); toput_char(finf,'\n');
	}
}
void escribe_todo_I(Bufferto8 *finf,u8int calcula_I,double f,float x,float y, float vv,float* N,uint n, const char16_t *unif, s8int decf){
	n++;

	towrite8_string(finf,TEXTOS[54]);

	towrite8_string(finf,"               f= ");
	setbuf_absolutep(finf,6);	//f>r, usually
	towrite8_aligned_double(finf,f,10);
	towrite8(finf,' ', 'w',unif, 0);
	if(calcula_I&1){
		setbuf_relativep(finf,2);
		towrite8_string(finf,"   ");
		towrite8_aligned_float(finf,sqrtf(vv*N[6*n]),9);
	}
	toput_char(finf,'\n');

	towrite8_string(finf,"              xp= ");
	if(!(calcula_I&2)) setbuf_limpio(finf);
	setbuf_absolutep(finf,decf);
	towrite8_aligned_double(finf,x,10);
	towrite8(finf,' ', 'w',unif, 0);
	if(calcula_I&2){
		setbuf_relativep(finf,2);
		towrite8_string(finf,"   ");
		towrite8_aligned_float(finf,sqrtf(vv*N[7*n]),9);
	}else{
		setbuf_nolimpio(finf);
	}
	toput_char(finf,'\n');

	towrite8_string(finf,"              yp= ");
	if(!(calcula_I&4)) setbuf_limpio(finf);
	setbuf_absolutep(finf,decf);
	towrite8_aligned_double(finf,y,10);
	towrite8(finf,' ', 'w',unif, 0);
	if(calcula_I&4){
		setbuf_relativep(finf,2);
		towrite8_string(finf,"   ");
		towrite8_aligned_float(finf,sqrtf(vv*N[8*n]),9);
	}else{
		setbuf_nolimpio(finf);
	}
	toput_char(finf,'\n');
}

#define towrite_s_semidiag(finf,unif,semidiag) \
	setbuf_noscientific(finf); setbuf_relativep(finf,6);\
	setbuf_limpio(finf);\
	towrite8(finf,'s',"  (", 'w',unif, 's',")    ,     s=r/", 'f',semidiag, 's'," (", 'w',unif, 's',")\n", 0);\
	setbuf_nolimpio(finf);

void escribe_todo_dist(Bufferto8 *finf, u8int _idioma, Distorsion *dist, float vv,float* N,uint n,uint n0, bint correl_a2f, const char16_t *unif, s8int decf){
	u8int modelo;
	uint n1=n+1;
	uint k;
	float faux;
	float imp_total;

	if(_idioma>MAX_IDIOMA) _idioma=0;
	const char8_t* const *TEX_TOS=TEXTOS_calibracion[_idioma];

	modelo=dist->config.modelo_poli;
	if(modelo==0){
		towrite8_string(finf,TEX_TOS[7]);
		return;
	}
	if(modelo>2){
		towrite8_string(finf,"\n          Error: modelo polinómico fuera de rango");
		return;
	}
	towrite8_many_strings(finf,TEX_TOS[0],TEX_TOS[modelo],"\n",NULL);
	imp_total=0;
	k=n0*n1;
	if(dist->config.param_radsim!=0){
		towrite8_many_strings(finf,TEX_TOS[3],TEX_TOS[4],NULL);
		u16int l=dist->config.param_radsim;
		for(u8int i=0;i<SIM_N;i++,l>>=1){
			if(!(l&1)) continue;
			towrite8(finf,'s',"               a", 'u',i+1, 's',"= ", 0);
			setbuf_absolutep(finf,decf);
			towrite8_aligned_float(finf,dist->valores_radsim[i],9); towrite8_string(finf,"  ");
			setbuf_relativep(finf,2);
			towrite8_aligned_float(finf,sqrtf(vv*N[k]),7); towrite8_string(finf,"      ");
			setbuf_absolutep(finf,decf);
			faux=fabsf(dist->valores_radsim[i])*Cantidad_p[modelo-1][i+1];
			imp_total+=faux*faux;
			towrite8_float(finf,faux); toput_char(finf,'\n');
			k+=n1;
		}
		if(correl_a2f){
			uint k1=6*n1+3;
			if((dist->config.param_radsim&2) && N[k1]!=0){
				towrite8_string(finf,TEX_TOS[5]);
				setbuf_relativep(finf,2);
				towrite8_float(finf,N[k1]/sqrtf(N[6*n1]*N[9*n1])); toput_char(finf,'\n');
			}
		}
		towrite8_string(finf,"\n                Dr= ");
		crea_formulac_simetricas(finf,false,modelo,dist->valores_radsim,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
	}
	if(dist->config.param_tansim!=0){
		towrite8_many_strings(finf,TEX_TOS[6],TEX_TOS[4],NULL);
		u16int l=dist->config.param_tansim;
		for(u8int i=0;i<SIM_N;i++,l>>=1){
			if(!(l&1)) continue;
			towrite8(finf,'s',"               b", 'u',i+1, 's',"= ", 0);
			setbuf_absolutep(finf,decf);
			towrite8_aligned_float(finf,dist->valores_tansim[i],9); towrite8_string(finf,"  ");
			setbuf_relativep(finf,2);
			towrite8_aligned_float(finf,sqrtf(vv*N[k]),7); towrite8_string(finf,"      ");
			setbuf_absolutep(finf,decf);
			faux=fabsf(dist->valores_tansim[i])*Cantidad_p[modelo-1][i+1];
			imp_total+=faux*faux;
			towrite8_float(finf,faux); toput_char(finf,'\n');
			k+=n1;
		}
		towrite8_string(finf,"\n                Dt= ");
		crea_formulac_simetricas(finf,false,modelo,dist->valores_tansim,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
	}
	if(dist->config.modelo_asim!=0){
		if(dist->config.modelo_asim>2){
			towrite8_string(finf,"\n          Error: modelo asimétrico fuera de rango");
			return;
		}
		towrite8_many_strings(finf,TEX_TOS[8],TEX_TOS[8+dist->config.modelo_asim],NULL);
	}
	if(dist->config.modelo_asim==CAL_MODASIM_RADTAN){
		if(dist->config.param_asim1!=0){
			towrite8_many_strings(finf,TEX_TOS[11],TEX_TOS[4],NULL);
			u16int l=dist->config.param_asim1;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"               c", 'u',i+1, 's',"= ", 0);
				setbuf_absolutep(finf,decf);
				u8int width=9; if(i+1>=10) width=8;
				towrite8_aligned_float(finf,dist->valores_asim1[i],width); towrite8_string(finf,"  ");
				setbuf_relativep(finf,2);
				towrite8_aligned_float(finf,sqrtf(vv*N[k]),7); towrite8_string(finf,"      ");
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=0.707F*fabsf(dist->valores_asim1[i]);
				imp_total+=faux*faux;
				towrite8_float(finf,faux); toput_char(finf,'\n');
				k+=n1;
			}
			towrite8_string(finf,"\n                Dr= ");
			crea_formulac_asimetrica_rt_s(finf,false,modelo,dist->valores_asim1,decf);
			towrite_s_semidiag(finf,unif,dist->config.semidiag);
		}
		if(dist->config.param_asim2!=0){
			towrite8_many_strings(finf,TEX_TOS[12],TEX_TOS[4],NULL);
			u16int l=dist->config.param_asim2;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"               d", 'u',i+1, 's',"= ", 0);
				setbuf_absolutep(finf,decf);
				u8int width=9; if(i+1>=10) width=8;
				towrite8_aligned_float(finf,dist->valores_asim2[i],width); towrite8_string(finf,"  ");
				setbuf_relativep(finf,2);
				towrite8_aligned_float(finf,sqrtf(vv*N[k]),7); towrite8_string(finf,"      ");
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=0.707F*fabsf(dist->valores_asim2[i]);
				imp_total+=faux*faux;
				towrite8_float(finf,faux); toput_char(finf,'\n');
				k+=n1;
			}
			towrite8_string(finf,"\n                Dt= ");
			crea_formulac_asimetrica_rt_s(finf,false,modelo,dist->valores_asim2,decf);
			towrite_s_semidiag(finf,unif,dist->config.semidiag);
		}
	}elif(dist->config.modelo_asim==CAL_MODASIM_VECTOR){
		if(dist->config.param_asim1!=0){
			towrite8_many_strings(finf,TEX_TOS[13],TEX_TOS[4],NULL);
			u16int l=dist->config.param_asim1;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"               c", 'u',i+1, 's',"= ", 0);
				setbuf_absolutep(finf,decf);
				u8int width=9; if(i>=10) width=8;
				towrite8_aligned_float(finf,dist->valores_asim1[i],width); towrite8_string(finf,"  ");
				setbuf_relativep(finf,2);
				towrite8_aligned_float(finf,sqrtf(vv*N[k]),7); towrite8_string(finf,"      ");
				setbuf_absolutep(finf,decf);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=fabsf(dist->valores_asim1[i]);
				if(i<2) faux*=0.707F;
				imp_total+=faux*faux;
				towrite8_float(finf,faux); toput_char(finf,'\n');
				k+=n1;
			}
		}
		if(dist->config.param_asim2!=0){
			towrite8_many_strings(finf,TEX_TOS[14],TEX_TOS[4],NULL);
			u16int l=dist->config.param_asim2;
			for(u8int i=0;i<ASIM_N;i++,l>>=1){
				if(!(l&1)) continue;
				towrite8(finf,'s',"               d", 'u',i+1, 's',"= ", 0);
				setbuf_absolutep(finf,decf);
				u8int width=9; if(i>=10) width=8;
				towrite8_aligned_float(finf,dist->valores_asim2[i],width); towrite8_string(finf,"  ");
				setbuf_relativep(finf,2);
				towrite8_aligned_float(finf,sqrtf(vv*N[k]),7); towrite8_string(finf,"      ");
				setbuf_absolutep(finf,2);
				float faux=Cantidad_pq[modelo-1][poli_asim[i+1]];
				faux*=fabsf(dist->valores_asim2[i]);
				if(i<2) faux*=0.707F;
				imp_total+=faux*faux;
				towrite8_float(finf,faux); toput_char(finf,'\n');
				k+=n1;
			}
		}
		towrite8_string(finf,"\n                Dr= ");
		crea_formulac_radasim_uv(finf,false,modelo,dist->valores_asim1,dist->valores_asim2,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
		towrite8_string(finf,"\n                Dt= ");
		crea_formulac_tanasim_uv(finf,false,modelo,dist->valores_asim1,dist->valores_asim2,decf);
		towrite_s_semidiag(finf,unif,dist->config.semidiag);
	}
	setbuf_absolutep(finf,decf);
	setbuf_nolimpio(finf);
	towrite8(finf,'s',TEX_TOS[15], 'f',sqrtf(imp_total),' ', 'w',unif, '\n', 0);
}
#undef towrite_s_semidiag

void escribe_residuosf(Bufferto8 *finf,int2* fm,uint ntot,Puntof* puntosf,char8_t* nombres, float* L){
	towrite8_string(finf,TEXTOS[63]);
	towrite8_string(finf,"         x          y         res. x     res. y\n\n");
	setbuf_relative(finf);
	dontimes(ntot,fm++){
		Puntof* punpf=puntosf+fm->n1;
		towrite8_string(finf,"      ");
		towrite8_aligned_string(finf,nombres+punpf->index,9); toput_char(finf,' ');
		setbuf_limpio(finf); finf->prec.signi=7;
		towrite8_aligned_double(finf,punpf->p.x,10); toput_char(finf,' ');
		towrite8_aligned_double(finf,punpf->p.y,10); toput_char(finf,' ');
		setbuf_nolimpio(finf); finf->prec.signi=2;
		towrite8_aligned_float(finf,*L,12); toput_char(finf,' '); L++;
		towrite8_aligned_float(finf,*L,10); toput_char(finf,'\n'); L++;
	}
}

void escribe_TLD_param(Bufferto8 *finf, double L[12],bint i){
	setbuf_relativep(finf,7);
	towrite8(finf,
		's',"            L1= ", 'f',L[0], '\n',
		's',"            L2= ", 'f',L[1], '\n',
		's',"            L3= ", 'f',L[2], '\n',
		's',"            L4= ", 'f',L[3], '\n',
		's',"            L5= ", 'f',L[4], '\n',
		's',"            L6= ", 'f',L[5], '\n',
		's',"            L7= ", 'f',L[6], '\n',
		's',"            L8= ", 'f',L[7], '\n',
	0);
	if(i) setbuf_absolutep(finf,7);
	towrite8(finf,
		's',"            L9= ", 'f',L[8], '\n',
		's',"           L10= ", 'f',L[9], '\n',
		's',"           L11= ", 'f',L[10], '\n',
	0);
	if(i) setbuf_relative(finf);
	towrite8(finf,'s',"           L12= ", 'f',L[11], '\n',0);
}
void escribe_TLDs(Bufferto8 *finf,float ratio,Parametros_valores param_valores,float lambda,float a,float b,float a2,float b2){
	Puntoxy_double p,q;
	double L[12];
	double M[3][3];
	Giro3D_double G;
	G.ω=param_valores.W;
	G.φ=param_valores.PHI;
	G.κ=param_valores.k;
	MatrizRot_ωφκ(G,M);
	double f=param_valores.f/lambda;
	L[0]=f*M[0][0];
	L[1]=f*M[0][1];
	L[2]=f*M[0][2];
	L[3]=-M[0][0]*param_valores.X+M[0][1]*param_valores.Y+M[0][2]*param_valores.Z;
	L[3]*=-f;
	L[4]=f*M[1][0];
	L[5]=f*M[1][1];
	L[6]=f*M[1][2];
	L[7]=M[1][0]*param_valores.X+M[1][1]*param_valores.Y+M[1][2]*param_valores.Z;
	L[7]*=-f;
	L[8]=-M[2][0];
	L[9]=-M[2][1];
	L[10]=-M[2][2];
	L[11]=M[2][0]*param_valores.X+M[1][1]*param_valores.Y+M[1][2]*param_valores.Z;

	p.x=L[0]; p.y=L[4];
	q=afin_ab_dbl(p,a,b);
	q=afin_ab_dbl(q,a2,b2);
	L[0]=q.x; L[4]=q.y;

	p.x=L[1]; p.y=L[5];
	q=afin_ab_dbl(p,a,b);
	q=afin_ab_dbl(q,a2,b2);
	L[1]=q.x; L[5]=q.y;

	p.x=L[2]; p.y=L[6];
	q=afin_ab_dbl(p,a,b);
	q=afin_ab_dbl(q,a2,b2);
	L[2]=q.x; L[6]=q.y;

	p.x=L[3]; p.y=L[7];
	q=afin_ab_dbl(p,a,b);
	q=afin_ab_dbl(q,a2,b2);
	L[3]=q.x; L[7]=q.y;

	double aux;

	aux=param_valores.x/lambda;
	L[0]+=aux*L[8];		L[1]+=aux*L[9];		L[2]+=aux*L[10];	L[3]+=aux*L[11];

	aux=param_valores.y/lambda;
	L[4]+=aux*L[8];		L[5]+=aux*L[9];		L[6]+=aux*L[10];	L[7]+=aux*L[11];

	if(ratio!=1.0F){
		double dbratio=(double)fabsf(ratio);
		L[0]*=dbratio;	L[1]*=dbratio;	L[2]*=dbratio;	L[3]*=dbratio;
		if(ratio<0){
			L[4]=-L[4];	L[5]=-L[5];	L[6]=-L[6];	L[7]=-L[7];
		}
	}

	towrite8_string(finf,u8"          x=(L1·X+L2·Y+L3·Z+L4)/(L9·X+L10·Y+L11·Z+L12)\n"
						u8"          y=(L5·X+L6·Y+L7·Z+L8)/(L9·X+L10·Y+L11·Z+L12)\n");
	//Normalizar a sqrt(...)=1
	aux=L[8]*L[8]+L[9]*L[9]+L[10]*L[10];
	aux=sqrt(aux);
	if(L[11]<0) aux=-aux;
	aux=1.0/aux;
	for(uint i=0;i<12;i++)
		L[i]*=aux;
	towrite8_many_strings(finf,TEXTOS[66],"L9^2+L10^2+L11^2=1\n\n",NULL);
	escribe_TLD_param(finf,L,true);
	//Normalizar a ..+..+..=1
	aux=1.0/(L[8]+L[9]+L[10]);
	for(uint i=0;i<12;i++)
		L[i]*=aux;
	towrite8_many_strings(finf,TEXTOS[66],"L9+L10+L11=1\n\n",NULL);
	escribe_TLD_param(finf,L,true);
	//Normalizar a L[11]=1;
	aux=1.0/L[11];
	for(uint i=0;i<12;i++)
		L[i]*=aux;
	towrite8_many_strings(finf,TEXTOS[66],"L12=1\n\n",NULL);
	escribe_TLD_param(finf,L,false);
}

/*void escribe_radial_distancias(Bufferto8 *finf,Config_distorsion* config_dist,float* Xradsim){
	float const d=0.1F;
	float s;
	u8int modelo=config_dist->modelo_poli;
	u16int parametros=config_dist->param_radsim;

	for(s=0;s<1.001;s+=d){	//1.001 por si acaso
		float dr=Radsim(modelo,parametros,Xradsim,s);
		towrite8(finf,'f',s*config_dist->semidiag,' ', 'f',dr, '\n',0);
	}
}*/

